import delimited "Regression_data_schools4to50.csv"

ren v1 Social_interaction_opt
ren v2 Social_interaction_obs
ren v3 Social_capital_opt
ren v4 Social_capital_obs
ren v5 avg_welfare
ren v6 num_students
ren v7 num_students_sq
ren v8 avg_geodist
ren v9 avg_outdegree
ren v10 avg_indegree
ren v11 avg_avgdeg
ren v12 std_outdegree
ren v13 std_indegree
ren v14 std_avgdeg
ren v15 female
ren v16 black
ren v17 grade
ren v18 GPA
ren v19 physical_dev
ren v20 religion_prac
ren v21 famsize
ren v22 twoparents
ren v23 peduc
ren v24 faminc
ren v25 faminc_refused

est clear

gen Ndiff=Social_interaction_opt - Social_interaction_obs
gen Sdiff=Social_capital_opt - Social_capital_obs

reg Ndiff num_students num_students_sq, robust
est store Ndiff1

reg Ndiff num_students num_students_sq avg_geodist, robust
est store Ndiff2

reg Ndiff num_students num_students_sq avg_geodist avg_outdegree std_outdegree, robust
est store Ndiff3

reg Ndiff num_students num_students_sq avg_geodist avg_outdegree std_outdegree female-faminc_refused, robust
est store Ndiff4

esttab Ndiff* using Table5_soc_int.csv, nogap stats(N r2)  title("Table 5")   r2(%8.3f) b(%8.3f) se(%8.3f) label star(* 0.10 ** 0.05 *** 0.01) append

est clear

reg Sdiff num_students num_students_sq, robust
est store Sdiff1

reg Sdiff num_students num_students_sq avg_geodist, robust
est store Sdiff2

reg Sdiff num_students num_students_sq avg_geodist avg_outdegree std_outdegree, robust
est store Sdiff3

reg Sdiff num_students num_students_sq avg_geodist avg_outdegree std_outdegree female-faminc_refused, robust
est store Sdiff4

esttab Sdiff* using Table6_soc_cap.csv, nogap stats(N r2)  title("Table 6")   r2(%8.3f) b(%8.3f) se(%8.3f) label star(* 0.10 ** 0.05 *** 0.01) append

est clear

reg avg_welfare num_students num_students_sq, robust
est store AWdiff1

reg avg_welfare num_students num_students_sq avg_geodist, robust
est store AWdiff2

reg avg_welfare num_students num_students_sq avg_geodist avg_outdegree std_outdegree, robust
est store AWdiff3

reg avg_welfare num_students num_students_sq avg_geodist avg_outdegree std_outdegree female-faminc_refused, robust
est store AWdiff4

esttab AWdiff* using Table7_AW.csv, nogap stats(N r2)  title("Table 7")   r2(%8.3f) b(%8.3f) se(%8.3f) label star(* 0.10 ** 0.05 *** 0.01) append
